/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * gimpoperationoverwrite.h
 * Copyright (C) 2025 Woynert <woynertgamer@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __GIMP_OPERATION_OVERWRITE_H__
#define __GIMP_OPERATION_OVERWRITE_H__


#include "gimpoperationlayermode.h"


#define GIMP_TYPE_OPERATION_OVERWRITE            (gimp_operation_overwrite_get_type ())
#define GIMP_OPERATION_OVERWRITE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIMP_TYPE_OPERATION_OVERWRITE, GimpOperationOverwrite))
#define GIMP_OPERATION_OVERWRITE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  GIMP_TYPE_OPERATION_OVERWRITE, GimpOperationOverwriteClass))
#define GIMP_IS_OPERATION_OVERWRITE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIMP_TYPE_OPERATION_OVERWRITE))
#define GIMP_IS_OPERATION_OVERWRITE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GIMP_TYPE_OPERATION_OVERWRITE))
#define GIMP_OPERATION_OVERWRITE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  GIMP_TYPE_OPERATION_OVERWRITE, GimpOperationOverwriteClass))


typedef struct _GimpOperationOverwrite      GimpOperationOverwrite;
typedef struct _GimpOperationOverwriteClass GimpOperationOverwriteClass;

struct _GimpOperationOverwrite
{
  GimpOperationLayerMode  parent_instance;
};

struct _GimpOperationOverwriteClass
{
  GimpOperationLayerModeClass  parent_class;
};


GType   gimp_operation_overwrite_get_type (void) G_GNUC_CONST;


#endif /* __GIMP_OPERATION_OVERWRITE_MODE_H__ */
