/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpbrush.h"
#include "core/gimpdatafactory.h"
#include "core/gimpgradient.h"
#include "core/gimppalette.h"
#include "core/gimpparamspecs.h"
#include "core/gimppattern.h"
#include "core/gimpresource.h"
#include "text/gimpfont.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
resource_id_is_valid_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint resource_id;
  gboolean valid = FALSE;

  resource_id = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpData *data = gimp_data_get_by_id (resource_id);

      valid = GIMP_IS_DATA (data);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), valid);

  return return_vals;
}

static GimpValueArray *
resource_id_is_brush_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint resource_id;
  gboolean brush = FALSE;

  resource_id = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpData *data = gimp_data_get_by_id (resource_id);

      brush = GIMP_IS_BRUSH (data);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), brush);

  return return_vals;
}

static GimpValueArray *
resource_id_is_pattern_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint resource_id;
  gboolean pattern = FALSE;

  resource_id = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpData *data = gimp_data_get_by_id (resource_id);

      pattern = GIMP_IS_PATTERN (data);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), pattern);

  return return_vals;
}

static GimpValueArray *
resource_id_is_gradient_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint resource_id;
  gboolean gradient = FALSE;

  resource_id = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpData *data = gimp_data_get_by_id (resource_id);

      gradient = GIMP_IS_GRADIENT (data);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), gradient);

  return return_vals;
}

static GimpValueArray *
resource_id_is_palette_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint resource_id;
  gboolean palette = FALSE;

  resource_id = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpData *data = gimp_data_get_by_id (resource_id);

      palette = GIMP_IS_PALETTE (data);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), palette);

  return return_vals;
}

static GimpValueArray *
resource_id_is_font_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint resource_id;
  gboolean font = FALSE;

  resource_id = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpData *data = gimp_data_get_by_id (resource_id);

      font = GIMP_IS_FONT (data);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), font);

  return return_vals;
}

static GimpValueArray *
resource_get_name_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpResource *resource;
  gchar *name = NULL;

  resource = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      name = g_strdup (gimp_object_get_name (GIMP_OBJECT (resource)));
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
resource_is_editable_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpResource *resource;
  gboolean editable = FALSE;

  resource = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      editable = gimp_data_is_writable (GIMP_DATA (resource));
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), editable);

  return return_vals;
}

static GimpValueArray *
resource_duplicate_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpResource *resource;
  GimpResource *resource_copy = NULL;

  resource = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpDataFactory *factory;

      factory = gimp_pdb_get_data_factory (gimp, G_TYPE_FROM_INSTANCE (resource));

      resource_copy = (GimpResource *)
        gimp_data_factory_data_duplicate (factory, GIMP_DATA (resource));

      if (! resource_copy)
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), resource_copy);

  return return_vals;
}

static GimpValueArray *
resource_rename_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpResource *resource;
  const gchar *new_name;

  resource = g_value_get_object (gimp_value_array_index (args, 0));
  new_name = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      if (gimp_viewable_is_name_editable (GIMP_VIEWABLE (resource)))
        {
          gimp_object_set_name (GIMP_OBJECT (resource), new_name);
        }
      else
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       _("Resource '%s' is not renamable"),
                      gimp_object_get_name (GIMP_OBJECT (resource)));
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
resource_delete_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpResource *resource;

  resource = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpDataFactory *factory;

      factory = gimp_pdb_get_data_factory (gimp, G_TYPE_FROM_INSTANCE (resource));

      if (gimp_data_is_deletable (GIMP_DATA (resource)))
        success = gimp_data_factory_data_delete (factory, GIMP_DATA (resource),
                                                 TRUE, error);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_resource_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-resource-id-is-valid
   */
  procedure = gimp_procedure_new (resource_id_is_valid_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-id-is-valid");
  gimp_procedure_set_static_help (procedure,
                                  "Returns TRUE if the resource ID is valid.",
                                  "This procedure checks if the given resource ID is valid and refers to an existing resource.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("resource-id",
                                                 "resource id",
                                                 "The resource ID to check",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("valid",
                                                         "valid",
                                                         "Whether the resource ID is valid",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-id-is-brush
   */
  procedure = gimp_procedure_new (resource_id_is_brush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-id-is-brush");
  gimp_procedure_set_static_help (procedure,
                                  "Returns whether the resource ID is a brush.",
                                  "This procedure returns TRUE if the specified resource ID is a brush.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("resource-id",
                                                 "resource id",
                                                 "The resource ID",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("brush",
                                                         "brush",
                                                         "TRUE if the resource ID is a brush, FALSE otherwise",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-id-is-pattern
   */
  procedure = gimp_procedure_new (resource_id_is_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-id-is-pattern");
  gimp_procedure_set_static_help (procedure,
                                  "Returns whether the resource ID is a pattern.",
                                  "This procedure returns TRUE if the specified resource ID is a pattern.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("resource-id",
                                                 "resource id",
                                                 "The resource ID",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("pattern",
                                                         "pattern",
                                                         "TRUE if the resource ID is a pattern, FALSE otherwise",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-id-is-gradient
   */
  procedure = gimp_procedure_new (resource_id_is_gradient_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-id-is-gradient");
  gimp_procedure_set_static_help (procedure,
                                  "Returns whether the resource ID is a gradient.",
                                  "This procedure returns TRUE if the specified resource ID is a gradient.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("resource-id",
                                                 "resource id",
                                                 "The resource ID",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("gradient",
                                                         "gradient",
                                                         "TRUE if the resource ID is a gradient, FALSE otherwise",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-id-is-palette
   */
  procedure = gimp_procedure_new (resource_id_is_palette_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-id-is-palette");
  gimp_procedure_set_static_help (procedure,
                                  "Returns whether the resource ID is a palette.",
                                  "This procedure returns TRUE if the specified resource ID is a palette.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("resource-id",
                                                 "resource id",
                                                 "The resource ID",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("palette",
                                                         "palette",
                                                         "TRUE if the resource ID is a palette, FALSE otherwise",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-id-is-font
   */
  procedure = gimp_procedure_new (resource_id_is_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-id-is-font");
  gimp_procedure_set_static_help (procedure,
                                  "Returns whether the resource ID is a font.",
                                  "This procedure returns TRUE if the specified resource ID is a font.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("resource-id",
                                                 "resource id",
                                                 "The resource ID",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("font",
                                                         "font",
                                                         "TRUE if the resource ID is a font, FALSE otherwise",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-get-name
   */
  procedure = gimp_procedure_new (resource_get_name_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-get-name");
  gimp_procedure_set_static_help (procedure,
                                  "Returns the resource's name.",
                                  "This procedure returns the resource's name.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_resource ("resource",
                                                         "resource",
                                                         "The resource",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The resource's name",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-is-editable
   */
  procedure = gimp_procedure_new (resource_is_editable_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-is-editable");
  gimp_procedure_set_static_help (procedure,
                                  "Whether the resource can be edited.",
                                  "Returns TRUE if you have permission to change the resource.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_resource ("resource",
                                                         "resource",
                                                         "The resource",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("editable",
                                                         "editable",
                                                         "TRUE if the resource can be edited",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-duplicate
   */
  procedure = gimp_procedure_new (resource_duplicate_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-duplicate");
  gimp_procedure_set_static_help (procedure,
                                  "Duplicates a resource.",
                                  "Returns a copy having a different, unique ID.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_resource ("resource",
                                                         "resource",
                                                         "The resource",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_resource ("resource-copy",
                                                             "resource copy",
                                                             "A copy of the resource.",
                                                             FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-rename
   */
  procedure = gimp_procedure_new (resource_rename_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-rename");
  gimp_procedure_set_static_help (procedure,
                                  "Renames a resource. When the name is in use, renames to a unique name.",
                                  "Renames a resource. When the proposed name is already used, GIMP generates a unique name.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_resource ("resource",
                                                         "resource",
                                                         "The resource",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("new-name",
                                                       "new name",
                                                       "The proposed new name of the resource",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-resource-delete
   */
  procedure = gimp_procedure_new (resource_delete_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-resource-delete");
  gimp_procedure_set_static_help (procedure,
                                  "Deletes a resource.",
                                  "Deletes a resource. Returns an error if the resource is not deletable. Deletes the resource's data. You should not use the resource afterwards.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2023");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_resource ("resource",
                                                         "resource",
                                                         "The resource",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
